<?php
// db.php for database conn
include('db.php');

// Initialize the response array
$response = array();

// Check if the 'id' parameter is provided in the URL
if (isset($_GET['id'])) {
    // Sanitize and validate the 'id'
    $customer_id = intval($_GET['id']); // Convert to an integer
    if ($customer_id <= 0) { // Validate: Ensure it's a positive number
        $response = array("message" => "Invalid Customer ID");
        echo json_encode($response);
        exit;
    }

    // Build the SQL query to fetch the total order count
    $query = "SELECT 
    c.id,
    c.displayname,
    c.customertype,
    i.invoice_no,
    SUM(i.Grand_total) AS totalamount
FROM customer c
LEFT JOIN invoice i ON i.user_id = c.id
WHERE c.id = $customer_id AND c.delete_status = 0";

$paymentsQuery = "
SELECT
    pc.Payment_id,
    pc.Payment_date,
    pc.Payment_type,
    pc.Amount,
    i.invoice_no AS transaction_no,
    'Invoice' AS transaction_type
FROM
    payment pc
LEFT JOIN
    invoice i ON pc.Invoice_id = i.invoice_id
WHERE
    pc.customer_id = $customer_id
    AND i.Delete_status = 0

UNION ALL

SELECT
    pc.Payment_id,
    pc.Payment_date,
    pc.Payment_type,
    pc.Amount,
    p.purchase_no AS transaction_no,
    'Purchase' AS transaction_type
FROM
    payment pc
LEFT JOIN
    purchase p ON pc.Purchase_id = p.purchase_id
WHERE
    pc.customer_id = $customer_id
    AND p.Delete_status = 0

ORDER BY Payment_date DESC";

$paymentResult = $conn->query($paymentsQuery);

while ($row = $paymentResult->fetch_assoc()) {
    $paymentDetails['payment'][] = [
        'paymentid' => htmlspecialchars($row['Payment_id']),
        'paymentdate' => htmlspecialchars($row['Payment_date']),
        'paymenttype' => htmlspecialchars($row['Payment_type']),
        'amount' => htmlspecialchars($row['Amount']),
        'transaction_no' => htmlspecialchars($row['transaction_no']),
        'transaction_type' => htmlspecialchars($row['transaction_type'])
    ];
}


    // Execute the query
    $result = mysqli_query($conn, $query);

    if ($result && mysqli_num_rows($result) > 0) {
        // Fetch the customer data as an associative array
        $response = mysqli_fetch_assoc($result); // Directly assign all data to the response
        $response['payments'] = $paymentDetails['payment'] ?? []; // Merge payment details
    } else {
        // No customer found
        $response = array("message" => "Customer not found");
    }
} else {
    // 'id' parameter not provided
    $response = array("message" => "Customer ID is required");
}

// Close the database conn
mysqli_close($conn);

// Return the response as JSON
header('Content-Type: application/json');
echo json_encode($response);
?>
